require 'rspec_helper'
require 'vaToolSet/vaToolSet_PageObject'
require 'loginLogout'

class AccessAssessmentBuilder
  include PageObject

  def initialize(driver)
    @driver = driver
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  def access_assessment_builder(user_info)
    log = LoginLogout.new(@driver)
    log.login(user_info)
    @vts_po.home.assessmentOpen_element.when_visible(TIME_OUT_LIMIT)
    @vts_po.home.assessmentOpen_element.focus
    @vts_po.home.assessmentOpen_element.click
  end

end